/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.model.RoomEdgeType;

@Singleton
public class RoomEdgeTypeDictionary {
    private ObjectMapper objectMapper = new ObjectMapper();
    private ConcurrentHashMap<Long, RoomEdgeType> byId = new ConcurrentHashMap();
    private Map<String, RoomEdgeType> byName = new ConcurrentHashMap<String, RoomEdgeType>();

    @Inject
    public RoomEdgeTypeDictionary() throws IOException {
        this(Gdx.files.internal("assets/definitions/room-edges.json"));
    }

    public RoomEdgeTypeDictionary(FileHandle roomEdgeDefinitionsJsonFile) throws IOException {
        List roomEdgeTypes = (List)this.objectMapper.readValue(roomEdgeDefinitionsJsonFile.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, RoomEdgeType.class));
        for (RoomEdgeType roomEdgeType : roomEdgeTypes) {
            if (this.byId.containsKey(roomEdgeType.getRoomEdgeTypeId())) {
                throw new IOException("Duplicate ID for room edge: " + roomEdgeType);
            }
            this.byId.put(roomEdgeType.getRoomEdgeTypeId(), roomEdgeType);
            this.byName.put(roomEdgeType.getRoomEdgeTypeName(), roomEdgeType);
        }
    }

    public RoomEdgeType getById(long id) {
        return this.byId.get(id);
    }

    public RoomEdgeType getByName(String name) {
        return this.byName.get(name);
    }

    public Iterable<RoomEdgeType> getAllDefinitions() {
        return this.byId.values();
    }
}

